{========================================================================}
{=                (c) 1995-99 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 22.03.99 - 15:52:03 $                                        =}
{========================================================================}
unit CDDBPro;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, MMObj, MMGauge, StdCtrls;

type
  TCDDBProgress = class(TForm)
    btnCancel: TButton;
    Label1: TLabel;
    Gauge: TMMGauge;
    Timer: TTimer;
    procedure FormShow(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure FormHide(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
  public
  end;

var
  CDDBProgress: TCDDBProgress;

implementation

uses CDMain;

{$R *.DFM}

{------------------------------------------------------------------------------}
procedure TCDDBProgress.FormCreate(Sender: TObject);
begin
   Caption := 'Connecting to '+CDMainForm.CDDB.Server;
end;

{------------------------------------------------------------------------------}
procedure TCDDBProgress.FormDestroy(Sender: TObject);
begin
   CDDBProgress := nil;
end;

{------------------------------------------------------------------------------}
procedure TCDDBProgress.FormShow(Sender: TObject);
begin
   Timer.Enabled := True;
end;

{------------------------------------------------------------------------------}
procedure TCDDBProgress.FormHide(Sender: TObject);
begin
   Timer.Enabled := False;
end;

{------------------------------------------------------------------------------}
procedure TCDDBProgress.TimerTimer(Sender: TObject);
begin
   if (Gauge.Progress = 100) then Gauge.Progress := 0;
   Gauge.Progress := Gauge.Progress+5;
end;

{------------------------------------------------------------------------------}
procedure TCDDBProgress.btnCancelClick(Sender: TObject);
begin
   Close;
end;

{------------------------------------------------------------------------------}
procedure TCDDBProgress.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   CDMainForm.CDDB.Abort := True;
end;

end.
